/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.ai;

import java.util.List;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.npc.LOTREntityAngbandBalrog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;

public class LOTREntityAIBalrogCharge2
extends LOTREntityAIAttackOnCollide {
    private LOTREntityAngbandBalrog theBalrog;
    private float chargeDist;
    private int frustrationTime;
    private boolean hitChargeTarget = false;
    private int chargingTick;

    public LOTREntityAIBalrogCharge2(LOTREntityAngbandBalrog balrog, double speed, float dist, int fr) {
        super(balrog, speed, false);
        this.theBalrog = balrog;
        this.chargeDist = dist;
        this.frustrationTime = fr;
    }

    @Override
    public boolean func_75250_a() {
        if (this.theBalrog.isBalrogCharging()) {
            return false;
        }
        boolean flag = super.func_75250_a();
        if (flag) {
            if (this.theBalrog.chargeFrustration >= this.frustrationTime) {
                return true;
            }
            double dist = this.theBalrog.func_70068_e((Entity)this.attackTarget);
            return dist >= (double)(this.chargeDist * this.chargeDist);
        }
        return false;
    }

    @Override
    public boolean func_75253_b() {
        if (!this.theBalrog.func_70089_S()) {
            return false;
        }
        this.attackTarget = this.theBalrog.func_70638_az();
        if (this.attackTarget == null || !this.attackTarget.func_70089_S()) {
            return false;
        }
        return this.chargingTick > 0 && !this.hitChargeTarget;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.theBalrog.setBalrogCharging(true);
        this.hitChargeTarget = false;
        this.chargingTick = 200;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.theBalrog.setBalrogCharging(false);
        this.hitChargeTarget = false;
        this.chargingTick = 0;
    }

    @Override
    public void func_75246_d() {
        this.updateLookAndPathing();
        if (this.chargingTick > 0) {
            --this.chargingTick;
        }
        AxisAlignedBB targetBB = this.theBalrog.field_70121_D.func_72314_b(0.5, 0.0, 0.5);
        double motionExtent = 2.0;
        float angleRad = (float)Math.atan2(this.theBalrog.field_70179_y, this.theBalrog.field_70159_w);
        targetBB = targetBB.func_72325_c((double)MathHelper.func_76134_b((float)angleRad) * motionExtent, 0.0, (double)MathHelper.func_76126_a((float)angleRad) * motionExtent);
        List hitTargets = this.worldObj.func_72839_b((Entity)this.theBalrog, targetBB);
        for (Object hitTarget : hitTargets) {
            EntityLivingBase hitEntity;
            Entity obj = (Entity)hitTarget;
            if (!(obj instanceof EntityLivingBase) || (hitEntity = (EntityLivingBase)obj) == this.theBalrog.field_70153_n) continue;
            float attackStr = (float)this.theBalrog.func_110148_a(LOTREntityAngbandBalrog.balrogChargeDamage).func_111126_e();
            boolean flag = hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.theBalrog), attackStr);
            if (!flag) continue;
            float knock = 2.5f;
            float knockY = 0.5f;
            hitEntity.func_70024_g((double)(-MathHelper.func_76126_a((float)((float)Math.toRadians(this.theBalrog.field_70177_z))) * knock), (double)knockY, (double)(MathHelper.func_76134_b((float)((float)Math.toRadians(this.theBalrog.field_70177_z))) * knock));
            hitEntity.func_70015_d(6);
            if (hitEntity != this.attackTarget) continue;
            this.hitChargeTarget = true;
        }
    }
}

